{$apptype GUI}
uses types,global_data,lang,menu,editor,grMainModule,graph,wincrt,grGUI,windows;

function GetCount(i,j:integer):integer;
var
  r, c ,count : integer;
begin

  count := 0;

  for r := i - 1 to i + 1 do
   for c := j - 1 to j + 1 do
    if (r >= 1) and (r <= actual_size) and
       (c >= 1) and (c <= actual_size) and
       not ((r = i) and (c = j)) and
       (mainmap[r,c] = 1) then inc(count);

  result :=count;
end;


procedure NextGeneration;
var
 i,j,c:integer;
 new_map:life_map;
begin
     for i := 1 to actual_size do
         for j := 1 to actual_size do begin
             c := GetCount(i, j);
             case mainmap[i,j] of
                  1: if (c > 3) or (c < 2) then new_map[i,j] := 0 else new_map[i,j] := mainmap[i,j];
                  0: if c = 3 then  new_map[i,j] := 1 else new_map[i,j] := mainmap[i,j];
             end;
         end;
     mainmap:=new_map;
     inc(generation_id);
end;


procedure showdecart;
var
  delta,i,count: integer;
  s:string;
begin
  setcolor(red);

  line(0,getmaxy -100, getmaxx, getmaxy -100);
  line(40, 0,40, getmaxy);

  setcolor(white);
  setfillstyle(1,white);

  delta:=40;

  i:=40;
  count:=0;
  while (i<getmaxx) do begin
    str(count,s);
    SetFillStyle(1, white);
    FillEllipse(i,getmaxy -100, 2, 2);
    outtextxy(i,getmaxy-100+5,s);
    inc(i,delta);
    inc(count,delta);
    if count < getmaxy then begin
     FillEllipse(40,getmaxy -100-i+40, 2, 2);
     outtextxy(40,getmaxy -100+5-i+40,s);
    end;
  end;

end;


procedure graph_stat(min_c, max_c: integer);
var
 i:longint;
begin
  cleardisplay;
  showdecart;
  setcolor(yellow);
  for i:=1 to count_arr do  begin
    line(40+i,getmaxy -100-1, 40+i,getmaxy -100-cells_arr[i] );
    if (cells_arr[i]=min_cells) or (cells_arr[i]=max_cells) then begin
     SetFillStyle(1, blue);
     setcolor(blue);
     FillEllipse(40+i,getmaxy -100-cells_arr[i], 3, 3);
     setcolor(yellow);
    end;

  end;
  button(50,getmaxy -50,'press any key',true, false, true);
  readkey;
  cleardisplay;
end;

procedure view_info;
var
  outstr:string;
begin
  setfillstyle(1,black);
  setcolor(black);
  bar(0,0,150,28);
  setcolor(green);
  str(generation_id,outstr);
  outstr:='Generation: '+outstr;
  outtextxy(10,10,outstr);

  str(cells,outstr);
  outstr:='Cells: '+outstr;
  outtextxy(10,20,outstr);

end;

procedure static_view;
begin

  setcolor(white);
  outtextxy(10,40,dialogs[2]+' [Shift+s]');
  outtextxy(10,50,dialogs[13]);
  outtextxy(10,60,dialogs[9]);
  outtextxy(10,70,dialogs[14]);
end;


procedure  start_life(max_iter: integer);
var
   v: byte;
   n:longint;
   key_press: byte;
   exit_act: boolean;
   pause_time:integer;
   err_code:integer;
   readstr:string;
   grid_view:boolean;
   runs: boolean;
begin
    clear_stat;
     runs:=false;
     pause_time:=0;
     cleardisplay;
     grid_view:=true;
     Grid;
     v:=0;
     n:=0;
     SetVisualPage(0);
     exit_act:=false;
     static_view;
     repeat
          if keypressed then begin
            key_press:= ord(readkey);
            if key_press=0 then begin
              key_press:=ord(readkey);
              case key_press of
                82: begin
                      grtextread(getmaxx div 2, getmaxy div 2, 'Enter time (ms):',readstr);
                      val(readstr,pause_time,err_code);
                      cleardisplay;
                      grid;
                    end;

              end;

            end else begin
            case key_press of
                71: begin
                      graph_stat(min_cells, max_cells);
                      if grid_view then grid;
                    end;
                27: exit_act:=true;
                103: if grid_view then begin
                        grid_view:=false;
                        cleardisplay;
                     end else begin
                        grid_view:=true;
                        grid;
                     end;
                115: save_current_map_to_file;
                82: if runs then runs:=false else runs:=true;
              end;
            end;

          end;
          inc(n);
          inc(v);
          if v > 5 then v := 0;

          SetActivePage(v);

          view_all_pix;
          view_info;
          SetVisualPage(v);
          if runs then begin
            NextGeneration;
            inc(count_arr);
            if count_arr>=1000 then count_arr:=1;
            cells_arr[count_arr] := cells;
            if cells> max_cells then max_cells:=cells;
            if cells<min_cells then min_cells:=cells;
            sleep(pause_time);
          end;
     until ((max_iter<>0) and (n=max_iter))or (exit_act);

end;


procedure generation;
var
   select_it: counter;
   filename:string;
   max_iter: longint;
   readstr:string;
   err_code:integer;
begin
     max_iter:=0;
     repeat
      cleardisplay;
      select_it:= show_menu(menu_life,4,1,style_ver);
      case     select_it of
      1: if open_file(filename)=0 then begin

              end else begin
                  Button(getmaxx div 2-50,getmaxy div 2 - 30,'Error, file bad!',true, false,true);
                  readkey;
              end;
      2: start_life(max_iter);
      3: begin
          cleardisplay;
          grtextread(getmaxx div 2-50,getmaxy div 2 - 30,'Steps count:(0 - Stop manually) ',readstr);
          val(readstr,max_iter,err_code);
          if err_code <>0 then max_iter:=0;
         end;
      end;
     until select_it = 4;
end;

function pp (var count:integer): integer;
begin
  inc(count,10);
  result:=count;
end;

procedure help();
var
 help_file: text;
 str_:string;
 strpos:integer;
begin
     strpos:=0;

     cleardisplay;
     assign(help_file, 'readme.txt');
     {$I-} reset(help_file); {$I+}
     setcolor(white);
     if ioresult<>0 then begin end else begin
        while not eof(help_file) do  begin

          readln(help_file,str_);
          outtextxy(10,pp(strpos),str_);

          if strpos mod 500 =0 then begin
             Button(getmaxx div 2-50,getmaxy - 60,'Press any key ...',true, false,true);
             readkey;
             strpos:=0;
             cleardisplay;
          end;
        end;
        close(help_file)
     end;
     Button(getmaxx div 2-50,getmaxy div 2 - 30,'Press any key ...',true, false,true);
     readkey
end;

procedure options;
var
 select:counter;
 read_str:string;
 err_code:integer;
begin
 repeat

  cleardisplay;
  select:=show_menu(menu_option,5,3,style_ver);
  case select of
   1:begin
      grtextread(getmaxx div 2-50,getmaxy div 2 -20,dialogs[4],read_str);
      val(read_str,color_grid,err_code);
     end;
   2:begin
      grtextread(getmaxx div 2-50,getmaxy div 2 -20,dialogs[4],read_str);
      val(read_str,color_cells,err_code);
     end;
   3:begin
      grtextread(getmaxx div 2-50,getmaxy div 2 -20,dialogs[5],read_str);
      val(read_str,size_of_block,err_code);
     end;
   4:begin
      grtextread(getmaxx div 2-50,getmaxy div 2 -20,dialogs[5],read_str);
      val(read_str,size_of_cells,err_code);
     end;
  end;
 until select=5;
end;

var
 select: counter;
begin
 gropen;

 repeat
       select := show_menu(main_menu,5,1,style_ver) ;

       case select of
       1: conf_editor;
       2: generation;
       3: options;
       4: help;
       end;

 until select = 5;
 GrClose;
end.
